<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output omit-xml-declaration="yes" method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>

<!-- Parameters for assigning a unique names to the graphical elements
	on the page. These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="movieNum" select="'default'"/>
<xsl:param name="aveRating" select="'0'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="productPage" select="'default'"/>
<xsl:param name="itemIDParam" select="'default'"/>
<xsl:param name="itemID"  select="'default'"/>
<xsl:param name="predRatingParam" select="'default'"/>
<xsl:param name="predRating" select="'default'"/>
<xsl:param name="dateAdded" select ="'default'"/>
<xsl:param name="deleteParam" select="'default'"/>
	

<xsl:template name="productURL">
	<xsl:value-of select="$productPage"/>?<xsl:value-of select="$itemIDParam"/>=<xsl:value-of select="$itemID"/>&amp;<xsl:value-of select="$predRatingParam"/>=<xsl:value-of select="$predRating"/>
</xsl:template>

<!--	Template for document root. Prevents the regurgitation of bad XML
-->
<xsl:template match="/">
    <xsl:apply-templates select="MOVIE"/>
</xsl:template>

<!-- Template for the movie: outputs a single table element
	(<td>) for inclusion in a table of movie recommendations.
-->
<xsl:template match="/MOVIE">
	<!-- Store product URL in parameter for fater multiple access.-->
	<xsl:param name="prodURL">
		<xsl:call-template name="productURL"/>	
	</xsl:param>
	<td>
		<!-- Remove from list checkbox -->
		<input type="checkbox" value="1" id="normaltext">
			<xsl:attribute name="name"><xsl:value-of select="$deleteParam"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$itemID"/></xsl:attribute>
		</input>
	</td>
	<td>
		<b><a><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute>
		<xsl:call-template name="movieLongName"/></a></b>
	</td>
	<td>
		<!--Start ratings  table w=190-->
		<table border="0" cellspacing="0" cellpadding="0">
		<tr valign="top"> 

			<td valign="top" align="center">
				<!-- rating title -->
				<img src="images/spacer.gif" width="126" height="13" border="0" alt="">
						<xsl:attribute name="name">title<xsl:value-of select="$movieNum"/></xsl:attribute>
				</img><br/>
				<!-- rating 'iguy' image -->
				<img src="images/iguy_null.gif" width="95" height="21" border="0"><xsl:attribute name="name">iguy<xsl:value-of select="$movieNum"/></xsl:attribute><xsl:attribute name="usemap">#iguyMap<xsl:value-of select="$movieNum"/></xsl:attribute></img><br/>
			<!-- line image for predicted rating -->
				<img src="images/spacer.gif" width="95" height="6" border="0" alt=""><xsl:attribute name="name">line<xsl:value-of select="$movieNum"/></xsl:attribute></img>
			</td>
		</tr>
		</table><!--End iguys table w=126-->
	</td>
	<td align="right">
		<span id="smalltext">
			<xsl:if test="$aveRating &gt; 0">Average Rating:&#160;<xsl:value-of select="$aveRating"/><br/></xsl:if>
			<xsl:value-of select="$dateAdded"/><br/>
		</span>
	</td>
</xsl:template>

</xsl:stylesheet>


